<?php
/**
 * @ Chess League Manager (CLM) Component 
 * @Copyright (C) 2008 Thomas Schwietert & Andreas Dorn. All rights reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fishpoke.de
 * @author Thomas Schwietert
 * @email fishpoke@fishpoke.de
 * @author Andreas Dorn
 * @email webmaster@sbbl.org
*/

defined('_JEXEC') or die('Restricted access');

//require('fpdf.php');

$lid = JRequest::getInt( 'liga', '1' ); 
$sid = JRequest::getInt( 'saison','1');
$view = JRequest::getVar( 'view');
// Variablen ohne foreach setzen
$liga=$this->liga;
$punkte=$this->punkte;
$spielfrei=$this->spielfrei;
$dwzschnitt=$this->dwzschnitt;
$mannschaft	=$this->mannschaft; 
$mleiter	=$this->mleiter; 
$count		=$this->count;      
$saison     =$this->saison; 
$bp			=$this->bp;
$sumbp		=$this->sumbp;
$einzel		=$this->einzel;
$plan		=$this->plan;
$termin		=$this->termin;
  
$name_liga = $liga[0]->name;
$anz_player = $liga[0]->stamm + $liga[0]->ersatz;

function vergleich($wert_a,$wert_b) {
	$a = 1000*($wert_a->dg) + 50*($wert_a->runde) + 2*($wert_a->paar) + $wert_a->heim;
	$b = 1000*($wert_b->dg) + 50*($wert_b->runde) + 2*($wert_b->paar) + $wert_b->heim;
	if ($a == $b) { return 0; }
	return ($a < $b) ? -1 : +1; 
}
$bpr = $bp;
usort($bpr, 'vergleich');

require(JPATH_COMPONENT.DS.'includes'.DS.'fpdf.php');

class PDF extends FPDF
{
//Kopfzeile
function Header()
{
	require(JPATH_COMPONENT.DS.'includes'.DS.'pdf_header.php');
}
//Fusszeile
function Footer()
{
	require(JPATH_COMPONENT.DS.'includes'.DS.'pdf_footer.php');
}
}

// Array für DWZ Schnitt setzen
$dwz = array();
for ($y=1; $y< ($liga[0]->teil)+1; $y++){
	$dwz[$dwzschnitt[($y-1)]->tlnr] = $dwzschnitt[($y-1)]->dwz; }
if (1 == 2) {
			echo "<br>dwz: ";
			var_dump($dwz);
			foreach ($dwz as $dwz1) {
				echo "<br>dwz1: ";
				var_dump($dwz1);
			}
		}
$dwz = array();
foreach ($count as $count1) {
	if (!isset($dwz[$count1->tln_nr])) {
		$countzz = 1;
		$countdd = 1;
		$countss = $count1->dwz;
		$dwz[$count1->tln_nr] = 0;
	} else {
		$countzz++;
		if ($count1->dwz > 0) {
			$countdd++;
			$countss = $countss + $count1->dwz; }
	} 
	if ($countzz == $liga[0]->stamm) {
		$dwz[$count1->tln_nr] = $countss / $countdd; }
}
if (1 == 2) {
			echo "<br>dwz: ";
			var_dump($dwz);
			foreach ($dwz as $dwz1) {
				echo "<br>dwz1: ";
				var_dump($dwz1);
			}
		}
//die();	
	
// Spielfreie Teilnehmer finden
$diff = $spielfrei[0]->count;

// Zellenhöhe -> Standard 6
$zelle = 6;
// Wert von Zellenbreite abziehen
// Bspl. für Standard (Null) für Liga mit 7 Runden und 1 Durchgang
$breite = 0;
// Fontgröße Standard = 12
$font = 12;
// Leere Zelle zum zentrieren
$leer = (3 * (10-($liga[0]->teil-$diff)))-$breite;
if ( $liga[0]->b_wertung == 0) $leer = $leer + 4;
if ($leer < 3) $leer = 3;
	
// Datum der Erstellung
$date =& JFactory::getDate();
$now = $date->toMySQL();

$pdf=new PDF();
$pdf->AliasNbPages();

//Deckblatt mit Kreuztabelle
$pdf->AddPage();

$pdf->SetFont('Times','',7);
	$pdf->Cell(10,3,' ',0,0);
	$pdf->Cell(175,2,utf8_decode(JText::_('WRITTEN')).' '.utf8_decode(JText::_('ON_DAY')).' '.utf8_decode(JHTML::_('date',  $now, JText::_('%d. %B %Y ,  %H %M'))),0,1,'R');
$pdf->SetFont('Times','B',14);
$pdf->Ln(30);
	$pdf->Cell(180,15,utf8_decode(JText::_('RANGLISTE_LIGAHEFT')),0,1,'C');
$pdf->SetFont('Times','B',16);	
	$pdf->Cell(180,15,utf8_decode($liga[0]->name),0,1,'C');
	$pdf->Cell(180,10,utf8_decode($saison[0]->name),0,1,'C');
	$pdf->Ln(30);    	
$pdf->SetFont('Times','',$font);
	$pdf->Cell($leer,$zelle,' ',0,0,'L');
	$pdf->Cell(7-$breite,$zelle,JText::_('RANG'),1,0,'C');
	$pdf->Cell(7-$breite,$zelle,JText::_('TLN'),1,0,'C');
	$pdf->Cell(60-2*$breite,$zelle,JText::_('TEAM'),1,0,'L');

// erster Durchgang
	for ($rnd=0; $rnd < $liga[0]->teil-$diff ; $rnd++) {
	$pdf->Cell(8-$breite,$zelle,$rnd+1,1,0,'C');
	}
// zweiter Durchgang
	if ($liga[0]->durchgang > 1) {
	for ($rnd=0; $rnd < $liga[0]->teil-$diff ; $rnd++) {
	$pdf->Cell(8-$breite,$zelle,$rnd+1,1,0,'C');
	}}
	$pdf->Cell(10-$breite,$zelle,JText::_('MP'),1,0,'C');
	$pdf->Cell(10-$breite,$zelle,JText::_('BP'),1,0,'C');
	if ( $liga[0]->b_wertung > 0) {
		$pdf->Cell(10-$breite,$zelle,JText::_('WP'),1,0,'C'); }
	$pdf->Ln();


// Anzahl der Teilnehmer durchlaufen
for ($x=0; $x< ($liga[0]->teil)-$diff; $x++){
	$pdf->Cell($leer,$zelle,' ',0,0,'L');
	$pdf->Cell(7-$breite,$zelle,$x+1,1,0,'C');
	$pdf->Cell(7-$breite,$zelle,$punkte[$x]->tln_nr,1,0,'C');
	$pdf->Cell(50-$breite,$zelle,utf8_decode($punkte[$x]->name),1,0,'L');
	$pdf->Cell(10-$breite,$zelle,(int)$dwz[($punkte[$x]->tln_nr)],1,0,'C');

// unschön aber läuft bis ich eine bessere Lösung gefunden habe  --> eine SQL Abfrage im MODEL
	$query = " SELECT a.tln_nr,a.gegner,a.runde, a.brettpunkte"
		." FROM #__clm_rnd_man as a "
		." WHERE a.lid = ".$lid
		." AND a.sid = ".$sid
		." AND a.tln_nr = ".$punkte[$x]->tln_nr
		." AND a.dg = 1"
		." ORDER BY a.gegner "
		;
	$db 	=& JFactory::getDBO();
	$db->setQuery( $query );
	$runden	=$db->loadObjectList();

	$query = " SELECT a.tln_nr,a.gegner,a.runde, a.brettpunkte"
		." FROM #__clm_rnd_man as a "
		." WHERE a.lid = ".$lid
		." AND a.sid = ".$sid
		." AND a.tln_nr = ".$punkte[$x]->tln_nr
		." AND a.dg = 2"
		." ORDER BY a.gegner "
		;
	$db->setQuery( $query );
	$runden_dg2 =$db->loadObjectList();

// Anzahl der Runden durchlaufen 1.Durchgang
	for ($y=0; $y< $liga[0]->teil-$diff; $y++) {
		if ($y == $x) {
			$pdf->Cell(8-$breite,$zelle,'X',1,0,'C'); }
		else {
			if ($punkte[$y]->tln_nr > $runden[0]->tln_nr) {
				$pdf->Cell(8-$breite,$zelle,$runden[($punkte[$y]->tln_nr)-2]->brettpunkte,1,0,'C'); 
				}
			if ($punkte[$y]->tln_nr < $runden[0]->tln_nr) {
				$pdf->Cell(8-$breite,$zelle,$runden[($punkte[$y]->tln_nr)-1]->brettpunkte,1,0,'C'); 
				}}}

// Anzahl der Runden durchlaufen 2.Durchgang
	if ($liga[0]->durchgang > 1) {
	for ($y=0; $y< $liga[0]->teil-$diff; $y++) {
		if ($y == $x) {
			$pdf->Cell(8-$breite,$zelle,'X',1,0,'C'); }
		else {
			if ($punkte[$y]->tln_nr > $runden_dg2[0]->tln_nr) {
				$pdf->Cell(8,$zelle-$breite,$runden_dg2[($punkte[$y]->tln_nr)-2]->brettpunkte,1,0,'C');
		}
			if ($punkte[$y]->tln_nr < $runden_dg2[0]->tln_nr) {
				$pdf->Cell(8-$breite,$zelle,$runden_dg2[($punkte[$y]->tln_nr)-1]->brettpunkte,1,0,'C');
		}}}}
// Ende Runden
	$pdf->Cell(10-$breite,$zelle,$punkte[$x]->mp,1,0,'C');
	$pdf->Cell(10-$breite,$zelle,$punkte[$x]->bp,1,0,'C');
	if ($liga[0]->b_wertung > 0) { 
		$pdf->Cell(10-$breite,$zelle,$punkte[$x]->wp,1,0,'C'); }
	$pdf->Ln();
	}
$pdf->Ln();
$pdf->Ln();

if ($liga[0]->bemerkungen <> "") {
	$pdf->SetFont('Times','B',$font);
	$pdf->Cell(10,$zelle,' ',0,0,'L');
	$pdf->Cell(150,$zelle,' '.utf8_decode(JText::_('NOTICE')).' :',0,1,'B');
	$pdf->SetFont('Times','',$font-2);
	$pdf->Cell(15,$zelle,' ',0,0,'L');
	$pdf->MultiCell(150,$zelle,utf8_decode($liga[0]->bemerkungen),0,'L',0);
	$pdf->Ln();
	}

	$pdf->SetFont('Times','B',$font);
	$pdf->Cell(10,$zelle,' ',0,0,'L');
	$pdf->Cell(150,$zelle,JText::_('CHIEF').' :',0,1,'L');
	$pdf->SetFont('Times','',$font-2);
	$pdf->Cell(15,$zelle,' ',0,0,'L');
	$pdf->Cell(150,$zelle,utf8_decode($liga[0]->sl),0,1,'L');
	$pdf->Cell(15,$zelle,' ',0,0,'L');
	$pdf->Cell(150,$zelle,$liga[0]->email,0,1,'L');
$pdf->Ln();
// Ende Teilnehmer

// Paarungen pro Spieltag
$pdf->AddPage();

$pdf->SetFont('Times','',7);
	$pdf->Cell(10,3,' ',0,0);
	$pdf->Cell(175,2,utf8_decode(JText::_('WRITTEN')).' '.utf8_decode(JText::_('ON_DAY')).' '.utf8_decode(JHTML::_('date',  $now, JText::_('%d. %B %Y ,  %H %M'))),0,1,'R');
	
$pdf->SetFont('Times','B',14);
	$pdf->Cell(10,15,' ',0,0);
	$pdf->Cell(80,15,utf8_decode($liga[0]->name)."  ".utf8_decode($saison[0]->name),0,0,'L');

$pdf->SetFont('Times','B',10);
	$pdf->Cell(10,5,' ',0,1);
	$pdf->Cell(10,5,' ',0,1);
	$pdf->Cell(10,8,' ',0,0);
	$pdf->Cell(80,8,utf8_decode(JText::_('TEAM_PLAN')),0,1,'L');
	
$pdf->SetFont('Times','',8);
	$pdf->Cell(10,8,' ',0,0);
	$pdf->Cell(12,8,JText::_('TEAM_ROUNDS'),0,0,'C');
	$pdf->Cell(12,8,JText::_('TEAM_PAIR'),0,0,'C');
	$pdf->Cell(30,8,JText::_('TEAM_DATE'),0,0,'L');
	$pdf->Cell(40,8,JText::_('TEAM_HOME'),0,0,'L');
	$pdf->Cell(40,8,JText::_('TEAM_GUEST'),0,0,'L');
	$pdf->Cell(8,8,'',0,1,'C');
	
	$cnt = 0;
	$ibpr = 0;
	foreach ($plan as $planl) { 
		//if (($planl->tln_nr !== $mannschaft[$m]->tln_nr) AND ($planl->gegner !== $mannschaft[$m]->tln_nr)) continue;
		$datum =& JFactory::getDate($planl->datum);
		$hpkt = "";
		$gpkt = "";
		if (isset($termin[$cnt]->nr)) {
			for ($icnt=0; $icnt<2; $icnt++) { 
				if (($planl->runde + $liga[0]->runden*($planl->dg -1)) > $termin[$cnt]->nr) {
					$cnt++;
					if ($pdf->GetY() > 240) {
						$pdf->AddPage();
						$pdf->SetFont('Times','',7);
						$pdf->Cell(10,3,' ',0,0);
						$pdf->Cell(175,2,utf8_decode(JText::_('WRITTEN')).' '.utf8_decode(JText::_('ON_DAY')).' '.utf8_decode(JHTML::_('date',  $now, JText::_('%d. %B %Y ,  %H %M'))),0,1,'R');
						$pdf->SetFont('Times','',8);
					}
					$pdf->Cell(8,2,'',0,1,'C');
				}
			}		
			if (($planl->runde + $liga[0]->runden*($planl->dg -1)) == $termin[$cnt]->nr) {
				$pdf->Cell(10,4,' ',0,0);
				$pdf->Cell(12,4,$planl->runde,0,0,'C');
				$pdf->Cell(12,4,$planl->paar,0,0,'C');
				$pdf->Cell(30,4,JHTML::_('date',  $termin[$cnt]->datum, JText::_('%d.%m.%Y')),0,0,'L');
				$pdf->Cell(40,4,utf8_decode($planl->hname),0,0,'L');
				$pdf->Cell(40,4,utf8_decode($planl->gname),0,0,'L');
				$pdf->Cell(2,4,'',0,0,'C');
			if (isset($bpr[$ibpr])) {
				if (($bpr[$ibpr]->runde == $planl->runde) AND ($bpr[$ibpr]->tln_nr == $planl->gegner)) $gpkt = $bpr[$ibpr]->brettpunkte;
				$ibpr++;
				if (($bpr[$ibpr]->runde == $planl->runde) AND ($bpr[$ibpr]->tln_nr == $planl->tln_nr)) $hpkt = $bpr[$ibpr]->brettpunkte;
				$ibpr++; 
			}
		$pdf->Cell(8,4,$hpkt,1,0,'C');
		$pdf->Cell(4,4,':',0,0,'C');
		$pdf->Cell(8,4,$gpkt,1,0,'C');
		$pdf->Cell(8,4,'',0,1,'C');
		
		}}
	}



//Mannschaften
$ic = 0;
$ie = 0;
$ib = 0;
for ($m=0; $m<$liga[0]->teil; $m++) {
	if ($mannschaft[$m]->name == "spielfrei") break;
$pdf->AddPage();

$pdf->SetFont('Times','',6);
	$pdf->Cell(10,3,' ',0,0);
	$pdf->Cell(175,4,utf8_decode(JText::_('WRITTEN')).' '.utf8_decode(JText::_('ON_DAY')).' '.utf8_decode(JHTML::_('date',  $now, JText::_('%d. %B %Y ,  %H %M'))),0,1,'R');
	
if ( $mannschaft[$m]->published == 0) {
	$pdf->SetFont('Times','',16);
	$pdf->Cell(10,15,utf8_decode(JText::_('TEAM')).' '.utf8_decode($mannschaft[$m]->name),0,1);
	$pdf->Cell(10,15,utf8_decode(JText::_('NOT_PUBLISHED')),0,0);
	$pdf->Ln();
	$pdf->Cell(10,15,utf8_decode(JText::_('GEDULD')),0,0);
} elseif (($mannschaft[0]->runden * $mannschaft[0]->dg) > 18) {
	$pdf->SetFont('Times','',16);
	$pdf->Cell(10,15,utf8_decode(JText::_('TEAM_PDF_LIMIT')),0,1);
	$pdf->Ln();
	$pdf->Cell(10,15,utf8_decode(JText::_('TEAM_PDF_ADVICE')),0,0);
} else {
$anzspl = $mannschaft[0]->runden * $mannschaft[0]->dg;
// Zellenhöhe -> Standard 6
$zelle = 7;
// Wert von Zellenbreite abziehen
// Bspl. für Standard (Null) für Liga mit 7 Runden und 1 Durchgang
if ($anzspl > 11) {
	$breite1 = 1;
	$breite = 6;
} else {
	$breite1 = 10;
	$breite = 8;
}
// Überschrift Fontgröße Standard = 12
$head_font = 14;
// Fontgröße Standard = 12
$font = 12;

$mf_name = "";
$mf_email = "";
$mf_tel_fest = "";
$mf_tel_mobil = "";
foreach ($mleiter as $mll) {
	if ($mannschaft[$m]->mf == $mll->mf) {
		$mf_name = $mll->mf_name;
		$mf_email = $mll->email;
		$mf_tel_fest = $mll->tel_fest;
		$mf_tel_mobil = $mll->tel_mobil;
		break;
	}
}
$pdf->SetFont('Times','B',14);
	$pdf->Cell(10,10,' ',0,0);
	$pdf->Cell(100,10,utf8_decode(JText::_('TEAM')).' : '.utf8_decode($mannschaft[$m]->name),0,1,'L');
$pdf->SetFont('Times','B',12);
	$pdf->Cell(10,10,' ',0,0);
	$pdf->Cell(100,10,utf8_decode(JText::_('LEAGUE')).' : '.utf8_decode($mannschaft[$m]->liga_name)."  ".$saison[0]->name,0,1,'L');
$pdf->SetFont('Times','B',10);
	$pdf->Cell(10,6,' ',0,0);
	$pdf->Cell(80,6,utf8_decode(Jtext::_('TEAM_LEADER')),0,0);
	$pdf->Cell(80,6,utf8_decode(substr(Jtext::_('TEAM_LOCATION'),3,(strlen(Jtext::_('TEAM_LOCATION'))-7))),0,1);
$pdf->SetFont('Times','',8);	
	$pdf->Cell(10,4,' ',0,0);
	if ($mf_name <> '') $pdf->Cell(80,4,utf8_decode($mf_name),0,0,'L');
	else $pdf->Cell(80,4,utf8_decode(JText::_('NOT_YET')),0,0,'L');
	if ($mannschaft[$m]->lokal <> '') $man = explode(",", $mannschaft[$m]->lokal);
	else $man = explode(",",utf8_decode(JText::_('NOT_YET')));
	if (isset($man[0])) $pdf->Cell(80,4,utf8_decode($man[0]),0,1);
	else $pdf->Cell(80,4,'',0,1);
$pdf->SetFont('Times','U',8);	
	$pdf->Cell(10,4,' ',0,0);
	$pdf->Cell(80,4,utf8_decode($mf_email),0,0,'L');
$pdf->SetFont('Times','',8);
	if (isset($man[1])) $pdf->Cell(80,4,utf8_decode($man[1]),0,1);
	else $pdf->Cell(80,4,'',0,1);
	
	$pdf->Cell(10,4,' ',0,0);
	if (($mf_tel_fest) <> '') $pdf->Cell(80,4,Jtext::_('TEAM_FON').utf8_decode($mf_tel_fest),0,0,'L');
	elseif ($mf_name <> '') $pdf->Cell(80,4,substr(Jtext::_('TEAM_NO_FONE'),0,(strlen(Jtext::_('TEAM_NO_FONE'))-4)),0,0,'L');
	else $pdf->Cell(80,4,'',0,0,'L');
	if (isset($man[2])) $pdf->Cell(80,4,utf8_decode($man[2]),0,1);
	else $pdf->Cell(80,4,'',0,1);
	
	$pdf->Cell(10,8,' ',0,0);
	if (($mf_tel_mobil) <> '') $pdf->Cell(80,4,Jtext::_('TEAM_MOBILE').utf8_decode($mf_tel_mobil),0,0,'L');
	elseif ($mf_name <> '') $pdf->Cell(80,4,substr(Jtext::_('TEAM_NO_MOBILE'),0,(strlen(Jtext::_('TEAM_NO_MOBILE'))-4)),0,0,'L');
	else $pdf->Cell(80,4,'',0,0,'L');
	if (isset($man[3])) $pdf->Cell(80,4,utf8_decode($man[3]),0,1);
	else $pdf->Cell(80,4,'',0,1);
	
$pdf->SetFont('Times','B',10);
	$pdf->Ln();
	$pdf->Cell(10,8,' ',0,0);
	$pdf->Cell(80,8,utf8_decode(JText::_('TEAM_FORMATION')),0,1,'L');
	
	if (!$count) {
		$pdf->SetFont('Times','',8);
		$pdf->Cell(80,8,utf8_decode(JText::_('NOT_YET')),0,1,'C');
	}
	else {

$pdf->SetFont('Times','',8);
	$pdf->Cell($breite1,8,' ',0,0);
	$pdf->Cell(12,8,JText::_('DWZ_NR'),0,0,'C');
	$pdf->Cell(40,8,JText::_('DWZ_NAME'),0,0);
	$pdf->Cell(10,8,JText::_('LEAGUE_STAT_DWZ'),0,0,'R');
	//if (!$count) 
	for ($b=0; $b<$mannschaft[$m]->runden; $b++) {
		$pdf->Cell($breite,8,$b+1,0,0,'C');
	}
	if ($mannschaft[$m]->dg >1) {
		for ($b=0; $b<$mannschaft[$m]->runden; $b++) {
			$pdf->Cell($breite,8,$b+1,0,0,'C');
	} }
	$pdf->Cell($breite,8,JText::_('TEAM_POINTS'),0,0,'C');
	$pdf->Cell($breite,8,JText::_('TEAM_GAMES'),0,0,'C');
	$pdf->Cell($breite,8,JText::_('LEAGUE_STAT_PERCENT'),0,1,'C');
	

// Teilnehmerschleife 	
	//$ie = 0;
	$sumspl = 0;
for ($x=0; $x< $anz_player; $x++){
	//echo '<br>'."x: ".$x."  ic: ".$ic."  count: ".$count[$ic]->rmnr."  mannschaft: ".$mannschaft[$m]->man_nr." count: ".utf8_decode($count[$ic]->name);
	//die();
	// Teilnehmerschleife 
	if (!$count[$ic]) break;
	if ($count[$ic]->tln_nr != $mannschaft[$m]->tln_nr) break;
	//$pdf->Cell($breite1,4,' ',0,0);
	if (!isset($count[$ic]->rrang)) {
		$pdf->Cell($breite1,4,' ',0,0);
		$pdf->Cell(12,4,($x+1),0,0,'C');
	} else {
		if ($count[$ic]->rmnr > $mannschaft[$m]->man_nr) {
		  if (($count[$ic]->tln_nr !== $einzel[$ie]->tln_nr)||($count[$ic]->zps !== $einzel[$ie]->zps)||($count[$ic]->mgl_nr !== $einzel[$ie]->spieler)) {
			$ic++;
			continue;
		  }
		}
		//echo '<br>'.utf8_decode($count[$ic]->name);
		$pdf->Cell($breite1,4,' ',0,0);
		$pdf->Cell(12,4,($count[$ic]->rrang),0,0,'C');
		}
	$pdf->Cell(40,4,utf8_decode($count[$ic]->name),0,0);
	$pdf->Cell(10,4,$count[$ic]->dwz,0,0,'R');
	$pkt = 0;
	$spl = 0;
  for ($c=0; $c<$mannschaft[$m]->dg; $c++) {
	for ($b=0; $b<$mannschaft[$m]->runden; $b++) {
		//echo '<br><br>'."ie: ".$ie."  einzel: ".$einzel[$ie]->tln_nr."  mannschaft: ".$mannschaft[$m]->tln_nr;
	//die();
	  //if (($einzel[$ie])&&($einzel[$ie]->dg==$c+1)&&($einzel[$ie]->runde==$b+1)&&($einzel[$ie]->snr==$x+1)&&($einzel[$ie]->tln_nr==$mannschaft[$m]->tln_nr)) {
		if (($einzel[$ie])&&($einzel[$ie]->dg==$c+1)&&($einzel[$ie]->runde==$b+1)&&($einzel[$ie]->tln_nr==$mannschaft[$m]->tln_nr)&&($count[$ic]->zps==$einzel[$ie]->zps)&&($count[$ic]->mgl_nr==$einzel[$ie]->spieler)) {
		$dr_einzel = "?";
		if (($einzel[$ie]->punkte==0)&&($einzel[$ie]->kampflos==0)) $dr_einzel = "0";
		if (($einzel[$ie]->punkte==0)&&($einzel[$ie]->kampflos==1)) $dr_einzel = "-";
		if (($einzel[$ie]->punkte==0)&&($einzel[$ie]->kampflos==2)) $dr_einzel = "-";
		if (($einzel[$ie]->punkte==1)&&($einzel[$ie]->kampflos==0)) $dr_einzel = "1";
		if (($einzel[$ie]->punkte==1)&&($einzel[$ie]->kampflos==1)) $dr_einzel = "+";
		if (($einzel[$ie]->punkte==1)&&($einzel[$ie]->kampflos==2)) $dr_einzel = "+";
		if ($einzel[$ie]->punkte==0.5) $dr_einzel = utf8_decode(chr(189));
		$pdf->Cell($breite,4,$dr_einzel,1,0,'C');
		$spl++;
		$sumspl++;
		$pkt = $pkt + $einzel[$ie]->punkte;
		$ie++;
	  }
	  else $pdf->Cell($breite,4,'',1,0,'C');
	  
	}
  }
	if ($spl>0) {
		$pdf->Cell($breite,4,$pkt,1,0,'C');
		$pdf->Cell($breite,4,$spl,1,0,'C');
		$prozent = round(100*($pkt/$spl));
		$pdf->Cell($breite,4,$prozent,1,0,'C');
	}
	else {
		$pdf->Cell($breite,4,"",1,0,'C');
		$pdf->Cell($breite,4,"",1,0,'C');
		$pdf->Cell($breite,4,"",1,0,'C');
	}
	$pdf->Cell($breite,4,'',0,1,'C');
	$ic++;
}
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$pdf->Line($x+$breite1,$y+2,$x+170,$y+2);
	$pdf->Cell(8,4,'',0,1,'C');
	
	$pdf->Cell($breite1,4,' ',0,0);
	$pdf->Cell(12,4,JText::_('TEAM_TOTAL'),0,0,'C');
	$pdf->Cell(40,4,'',0,0);
	$pdf->Cell(10,4,'',0,0,'R');
	$pktsumme = 0;
	$spl = 0;
  for ($c=0; $c<$mannschaft[$m]->dg; $c++) {
	for ($b=0; $b<$mannschaft[$m]->runden; $b++) {
			//echo '<br>'." m: ".$m." c: ".$c." b: ".$b." ib: ".$ib."  runde: ".$bp[$ib]->runde."  tln_nr: ".$bp[$ib]->tln_nr."/".$mannschaft[$m]->tln_nr."  brettpunkt: ".$bp[$ib]->brettpunkte."  pktsumme: ".$pktsumme;
		if (isset($bp[$ib]->runde) AND $bp[$ib]->runde == $b+1 AND $bp[$ib]->tln_nr == $mannschaft[$m]->tln_nr) { 
			$pdf->Cell($breite,4,$bp[$ib]->brettpunkte,1,0,'C');
			$pktsumme = $pktsumme + $bp[$ib]->brettpunkte;
			//$ib++;
		}
		else $pdf->Cell($breite,4,'',1,0,'C');
		$ib++;
	}
  }
	if ($sumspl>0) {
		$pdf->Cell($breite,4,$pktsumme,1,0,'C');
		$pdf->Cell($breite,4,$sumspl,1,0,'C');
		$prozent = round(100*($pktsumme/$sumspl));
		$pdf->Cell($breite,4,$prozent,1,0,'C');
	}
	else {
		$pdf->Cell($breite,4,"",1,0,'C');
		$pdf->Cell($breite,4,"",1,0,'C');
		$pdf->Cell($breite,4,"",1,0,'C');
	}
	$pdf->Cell($breite,4,'',0,1,'C');
}
	$pdf->Ln();

$pdf->SetFont('Times','B',10);
	$pdf->Ln();
	$pdf->Cell(10,8,' ',0,0);
	$pdf->Cell(80,8,utf8_decode(JText::_('TEAM_PLAN')),0,1,'L');
	
$pdf->SetFont('Times','',8);
	$pdf->Cell(10,8,' ',0,0);
	$pdf->Cell(12,8,JText::_('TEAM_ROUNDS'),0,0,'C');
	$pdf->Cell(12,8,JText::_('TEAM_PAIR'),0,0,'C');
	$pdf->Cell(30,8,JText::_('TEAM_DATE'),0,0,'L');
	$pdf->Cell(40,8,JText::_('TEAM_HOME'),0,0,'L');
	$pdf->Cell(40,8,JText::_('TEAM_GUEST'),0,0,'L');
	$pdf->Cell(8,8,'',0,1,'C');
	
	$cnt = 0;
	$ibpr = 0;
	foreach ($plan as $planl) { 
		if (($planl->tln_nr !== $mannschaft[$m]->tln_nr) AND ($planl->gegner !== $mannschaft[$m]->tln_nr)) continue;
		$datum =& JFactory::getDate($planl->datum);
		$pdf->Cell(10,4,' ',0,0);
		$pdf->Cell(12,4,$planl->runde,0,0,'C');
		$pdf->Cell(12,4,$planl->paar,0,0,'C');
		if (isset($termin[$cnt]->nr) AND ($planl->runde + $mannschaft[$m]->runden*($planl->dg -1))== $termin[$cnt]->nr) { 
			$pdf->Cell(30,4,JHTML::_('date',  $termin[$cnt]->datum, JText::_('%d.%m.%Y')),0,0,'L');
			$cnt++;
			$pdf->Cell(40,4,utf8_decode($planl->hname),0,0,'L');
			$pdf->Cell(40,4,utf8_decode($planl->gname),0,0,'L');
			$pdf->Cell(2,4,'',0,0,'C');
		for ($b=0; $b<($liga[0]->teil); $b++) {
			if ((!isset($bpr[$ibpr])) OR ($bpr[$ibpr]->runde > $planl->runde)) break;
			if (($bpr[$ibpr]->runde == $planl->runde) AND ($bpr[$ibpr]->tln_nr == $planl->tln_nr)) $hpkt = $bpr[$ibpr]->brettpunkte;
			if (($bpr[$ibpr]->runde == $planl->runde) AND ($bpr[$ibpr]->tln_nr == $planl->gegner)) $gpkt = $bpr[$ibpr]->brettpunkte;
			$ibpr++; 
		}
		$pdf->Cell(8,4,$hpkt,1,0,'C');
		$pdf->Cell(4,4,':',0,0,'C');
		$pdf->Cell(8,4,$gpkt,1,0,'C');
		$pdf->Cell(8,4,'',0,1,'C');
		
		}
	}
}}
 
// Ausgabe
$pdf->Output(JText::_('RANGLISTE_LIGAHEFT').' '.utf8_decode($liga[0]->name).'.pdf','D');

?>